local S = minetest.get_translator(minetest.get_current_modname())
local mofood_longdesc = S("A delicious dish made from fresh ingredients.")

local function register_food_item(name, description, image, saturation, eat_value)
    minetest.register_craftitem(name, {
        description = description,
        _doc_items_longdesc = mofood_longdesc,
        inventory_image = image,
        groups = {food = 2, eatable = eat_value},
        _mcl_saturation = saturation,
        on_place = minetest.item_eat(eat_value),
        on_secondary_use = minetest.item_eat(eat_value),
    })
end

register_food_item("italian_food:pizza", S("Pizza"), "pizza.png", 16, 15)
register_food_item("italian_food:spaghetti", S("Tomato Spaghetti"), "spaghetti.png", 12, 10)
register_food_item("italian_food:dough", S("Dough"), "dough.png", 10, 10)
register_food_item("italian_food:spaghetti_raw", S("Raw Spaghetti"), "spaghetti_raw.png", 10, 10)
register_food_item("italian_food:raviolo_raw", S("Raw Raviolo"), "raviolo.png", 12, 12)
register_food_item("italian_food:gnocco_raw", S("Raw Gnocco"), "gnocco.png", 11, 10)
register_food_item("italian_food:fazzoletto_raw", S("Raw Fazzoletto"), "fazzoletti.png", 11, 11)
register_food_item("italian_food:bruschetta", S("Bruschetta"), "bruschetta.png", 20, 18)
register_food_item("italian_food:canoli", S("Cannoli"), "canoli.png", 20, 18)
register_food_item("italian_food:mozzarella", S("Mozzarella"), "mozzarella.png", 8.5, 9)
register_food_item("italian_food:tomato", S("Tomato"), "tomato.png", 8.5, 9)
register_food_item("italian_food:basil", S("Basil"), "basil.png", 3,4)
register_food_item("italian_food:tomato_sauce", S("Tomato Sauce"), "tomato_sauce.png", 7.5,8)
register_food_item("italian_food:pesto_sauce", S("Pesto Sauce"), "pesto_sauce.png", 7.5,8)
register_food_item("italian_food:tiramisu", S("Tiramisu"), "tiramisu.png", 12, 8)
register_food_item("italian_food:ice_cream", S("Chocolate Ice Cream"), "ice_cream.png", 8, 12)
register_food_item("italian_food:cone", S("Ice Cream Cone"), "cone.png", 4, 6)
register_food_item("italian_food:panettone", S("Panettone"), "panettone.png", 7, 8)
register_food_item("italian_food:pandoro", S("Pandoro"), "pandoro.png", 7, 8)
register_food_item("italian_food:coffee", S("Coffee"), "coffee.png", 7.5,8)

-- Crafting
minetest.register_craft({
    output = "italian_food:dough",
    recipe = {
        {"", "mcl_farming:wheat_item", ""}, 
        {"mcl_farming:wheat_item", "mcl_farming:wheat_item", "mcl_farming:wheat_item"}, --good
        {"", "mcl_farming:wheat_item", ""}, 
    },
})

minetest.register_craft({
    output = "italian_food:pizza",
    recipe = {
        {"", "italian_food:mozzarella", ""}, 
        {"italian_food:tomato_sauce", "italian_food:tomato_sauce", "italian_food:tomato_sauce"}, --good
        {"italian_food:dough", "italian_food:dough", "italian_food:dough"}, 
    },
})

minetest.register_craft({
	output = "italian_food:spaghetti",
	recipe = {
        {"", "italian_food:tomato_sauce", ""}, 
        {"", "italian_food:spaghetti_raw", ""}, --good
        {"", "", ""}, 
    },
})

minetest.register_craft({
	output = "italian_food:bruschetta",
	recipe = {
        {"", "italian_food:tomato", ""}, 
        {"", "mcl_farming:bread", ""}, --good
        {"", "", ""}, 
    },
})

minetest.register_craft({
    output = "italian_food:tiramisu",
    recipe = {
        {"mcl_cocoas:cocoa_beans", "mcl_core:sugar", "mcl_cocoas:cocoa_beans"},
		{"mcl_cocoas:cocoa_beans", "mcl_mobitems:milk_bucket", "mcl_cocoas:cocoa_beans"},      -- good
        {"", "", ""},
    },
})

minetest.register_craft({
    output = "italian_food:gnocco_raw",
    recipe = {
        {"", "mcl_farming:potato_item", ""},
        {"mcl_farming:potato_item", "mcl_farming:potato_item", "mcl_farming:potato_item"},      --good
        {"", "mcl_farming:potato_item", ""},
    },
})

minetest.register_craft({
    output = "italian_food:tomato_sauce",
    recipe = {
        {"","italian_food:tomato", ""},
        {"", "mcl_potions:water", ""},      --good
        {"", "", ""},
    },
})
minetest.register_craft({
    output = "italian_food:pesto_sauce",
    recipe = {
        {"","italian_food:basil", ""},
        {"", "mcl_potions:water", ""},      --good
        {"", "", ""},
    },
})
minetest.register_craft({
    output = "italian_food:coffee",
    recipe = {
        {"","mcl_cocoas:cocoa_beans", ""},
        {"", "mcl_potions:water", ""},      --good
        {"", "", ""},
    },
})
minetest.register_craft({
	type = "cooking",
	output = "italian_food:mozzarella",                                  --good
	recipe = "mcl_mobitems:milk_bucket",
	replacements = {
		{"mcl_mobitems:milk_bucket", "mcl_buckets:bucket_empty"},
	},
})
minetest.register_craft({
    output = "italian_food:ice_cream",
    recipe = {
        {"mcl_core:sugar","mcl_core:ice", "mcl_core:sugar"},
        {"", "mcl_cocoas:cocoa_beans", ""},      --good
        {"", "italian_food:cone", ""},
    },
})
minetest.register_craft({
    output = "italian_food:cone",
    recipe = {
        {"","mcl_core:sugar", ""},
        {"", "mcl_mobitems:milk_bucket", ""},      --good
        {"", "mcl_throwing:egg", ""},
    },
})
minetest.register_craft({
    output = "italian_food:pandoro",
    recipe = {
        {"","mcl_core:sugar", ""},
        {"", "italian_food:dough", ""},      --good
        {"", "mcl_throwing:egg", ""},
    },
})
minetest.register_craft({
    output = "italian_food:panettone",
    recipe = {
        {"","mcl_cocoas:cocoa_beans", ""},
        {"", "italian_food:dough", ""},      --good
        {"", "mcl_throwing:egg", ""},
    },
})
minetest.register_craft({
    output = "italian_food:raviolo_raw",
    recipe = {
        {"italian_food:dough", "italian_food:dough", "italian_food:dough"}, 
        {"italian_food:dough", "mcl_mobitems:beef", "italian_food:dough"},      --good
        {"italian_food:dough", "italian_food:dough", "italian_food:dough"}, 
    },
})
minetest.register_craft({
    output = "italian_food:cannoli",
    recipe = {
        {"","mcl_cocoas:cocoa_beans", ""},
        {"", "italian_food:dough", ""},      --good
        {"", "mcl_throwing:egg", ""},
    },
})

-- plants
minetest.register_node("italian_food:basil_plant", {
    description = S("Basil Plant"),
    drawtype = "plantlike",
    tiles = {"basil_plant.png"},
    groups = {snappy = 3, flammable = 2, plant = 1},
    sounds = default and default.node_sound_leaves_defaults() or nil,
    drop = "italian_food:basil",
    sunlight_propagates = true,
    walkable = false,
    buildable_to = true,
})

minetest.register_abm({
    nodenames = {"group:grass"},
    neighbors = {"group:soil"},
    interval = 60,
    chance = 30, 
    action = function(pos, node)
        local basil_pos = {x = pos.x, y = pos.y + 1, z = pos.z}
        if minetest.get_node(basil_pos).name == "air" then
            if minetest.get_node(pos).name == "group:grass" then
                minetest.set_node(basil_pos, {name = "italian_food:basil_plant"})
            end
        end
    end
})

minetest.register_node("italian_food:tomato_plant", {
    description = S("Tomato Plant"),
    drawtype = "plantlike",
    tiles = {"tomato_plant.png"},
    groups = {snappy = 3, flammable = 2, plant = 1},
    sounds = default and default.node_sound_leaves_defaults() or nil,
    drop = "italian_food:tomato",
    sunlight_propagates = true,
    walkable = false,
    buildable_to = true,
})

minetest.register_abm({
    nodenames = {"group:grass"},
    neighbors = {"group:soil"},
    interval = 60,
    chance = 30, 
    action = function(pos, node)
        local basil_pos = {x = pos.x, y = pos.y + 1, z = pos.z}
        if minetest.get_node(basil_pos).name == "air" then
            minetest.set_node(basil_pos, {name = "italian_food:basil_plant"})
        end
    end
})
